/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.search;

import com.aptana.editor.php.core.model.IMethod;
import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.core.typebinding.IBinding;
import java.util.List;
import org2.eclipse.php.internal.core.CoreMessages;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ASTNodes;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org2.eclipse.php.internal.core.ast.nodes.ClassName;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org2.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.Include;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.Variable;
import org2.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org2.eclipse.php.internal.core.search.IOccurrencesFinder;
import org2.eclipse.php.internal.core.search.Messages;

public class IncludeOccurrencesFinder
extends AbstractOccurrencesFinder {
    private static final String INCLUDE_POINT_OF = CoreMessages.getString("IncludeOccurrencesFinder.0");
    public static final String ID = "RequireFinder";
    private IModelElement source;
    private IBinding binding;
    private Include includeNode;
    private List<IType> types;
    private List<IMethod> methods;

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.includeNode = this.getIncludeExpression(node);
        if (this.includeNode != null) {
            this.binding = this.includeNode.resolveBinding();
            if (this.binding == null) {
                return null;
            }
            this.source = this.binding.getPHPElement();
            if (this.source != null) {
                ISourceModule module = (ISourceModule)this.source;
                try {
                    this.types = module.getTopLevelTypes();
                    this.methods = module.getTopLevelMethods();
                    return null;
                }
                catch (Exception exception) {
                    this.fDescription = "MethodExitsFinder_occurrence_exit_description";
                    return this.fDescription;
                }
            }
        }
        this.fDescription = "MethodExitsFinder_occurrence_exit_description";
        return this.fDescription;
    }

    private final Include getIncludeExpression(ASTNode node) {
        boolean isInclude;
        boolean bl = isInclude = node != null && node.getType() == 36;
        if (isInclude) {
            return (Include)node;
        }
        ASTNode parent = ASTNodes.getParent(node, Include.class);
        return parent != null && parent.getType() == 36 ? (Include)parent : null;
    }

    @Override
    protected void findOccurrences() {
        if (this.source == null) {
            return;
        }
        this.fDescription = Messages.format(INCLUDE_POINT_OF, this.source.getElementName());
        this.getASTRoot().accept(this);
        int offset = this.includeNode.getStart();
        int length = this.includeNode.getLength();
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, length, this.getOccurrenceType(null), this.fDescription));
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 5;
    }

    @Override
    public String getElementName() {
        return this.binding.getName();
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getJobLabel() {
        return "RncludeFinder_job_label";
    }

    @Override
    public int getSearchKind() {
        return 7;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return "IncludeFinder_label_plural";
    }

    @Override
    public String getUnformattedSingularLabel() {
        return "IncludeFinder_label_singular";
    }

    @Override
    public boolean visit(ClassName className) {
        Expression expression = className.getName();
        this.markImportedTypes(expression);
        return false;
    }

    @Override
    public boolean visit(ClassDeclaration classDeclaration) {
        Expression superClass = classDeclaration.getSuperClass();
        this.markImportedTypes(superClass);
        List<Identifier> interfaces = classDeclaration.interfaces();
        for (Identifier interfaceIdentifier : interfaces) {
            this.markImportedTypes(interfaceIdentifier);
        }
        return false;
    }

    @Override
    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        return super.visit(interfaceDeclaration);
    }

    @Override
    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        ClassName className = classInstanceCreation.getClassName();
        Expression expression = className.getName();
        this.markImportedTypes(expression);
        return false;
    }

    private void markImportedTypes(Expression expression) {
        String name = null;
        if (expression == null) {
            return;
        }
        if (expression.getType() == 65) {
            name = ((NamespaceName)expression).getName();
        }
        if (name == null && expression.getType() == 33) {
            Identifier id = (Identifier)expression;
            name = id.getName();
        }
        if (name != null) {
            for (IType type : this.types) {
                if (!type.getElementName().equals(name)) continue;
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(expression.getStart(), expression.getLength(), this.getOccurrenceType(null), this.fDescription));
            }
        }
    }

    @Override
    public boolean visit(Identifier className) {
        StructuralPropertyDescriptor location = className.getLocationInParent();
        if (location == ClassDeclaration.SUPER_CLASS_PROPERTY || location == ClassDeclaration.INTERFACES_PROPERTY || location == StaticMethodInvocation.CLASS_NAME_PROPERTY || location == FormalParameter.PARAMETER_TYPE_PROPERTY) {
            String name = className.getName();
            for (IType type : this.types) {
                if (!type.getElementName().equals(name)) continue;
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(className.getStart(), className.getLength(), this.getOccurrenceType(null), this.fDescription));
            }
        }
        return false;
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        Expression functionName2 = functionInvocation.getFunctionName().getName();
        if (functionName2.getType() == 60) {
            functionName2 = ((Variable)functionName2).getName();
        }
        if (functionName2.getType() == 33) {
            Identifier id = (Identifier)functionName2;
            String name = id.getName();
            for (IMethod method : this.methods) {
                if (!method.getElementName().equals(name)) continue;
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(functionInvocation.getStart(), functionInvocation.getLength(), this.getOccurrenceType(null), this.fDescription));
            }
        }
        return true;
    }
}

